<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\LoginController;
use App\Http\Controllers\Api\StaffAdminController;
use App\Http\Controllers\Api\BuilderAdminController;
use App\Http\Controllers\Api\LocationController;
use App\Http\Controllers\Api\BuilderController;
use App\Http\Controllers\Api\RecordController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});


Route::post('/login',[LoginController::class, 'login']);

//Staff Admin Api

Route::post('/staff-list',[StaffAdminController::class, 'staffList']);
Route::post('/create-staff',[StaffAdminController::class, 'staffCreate']);

Route::post('/check-date',[StaffAdminController::class, 'checkDate']);
Route::post('/create-staff-test',[StaffAdminController::class, 'staffCreateTest']);
Route::post('/delete-staff-test',[StaffAdminController::class, 'staffDeleteTest']);
//builder admin api
Route::post('/builder-list',[BuilderAdminController::class, 'clientsList']);
Route::post('/create-builder',[BuilderAdminController::class, 'clientCreate']);

//other routes
Route::post('/location-list',[LocationController::class, 'staffLocations']);
Route::post('/builder-location-list',[LocationController::class, 'builderLocations']);
Route::post('/location-reports',[LocationController::class, 'locationsReports']);

Route::post('/location-add',[LocationController::class, 'staffLocationAdd']);
Route::post('/builder-list-forreport',[BuilderController::class, 'builderList']);
Route::post('/create-report',[RecordController::class, 'store']);
Route::post('/image-upload',[RecordController::class, 'imageUpload']);

Route::post('/report-list',[RecordController::class, 'reportList']);
Route::post('/report-list-Bulder-Admin',[RecordController::class, 'reportListByBuilderAdmin']);
Route::post('/report-detail',[RecordController::class, 'reportDetail']);
Route::post('/delete-image',[RecordController::class, 'imageDelete']);

