@extends('layouts.main-layout')

@section('content')
    <!--**********************************
                                        Content body start
                                    ***********************************-->
    <div class="content-body">

        <div class="row page-titles mx-0">
            <div class="col p-md-0">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ url('/') }}">Dashboard</a></li>
                    <li class="breadcrumb-item active"><a href="">Staff Admins</a></li>
                </ol>
            </div>
        </div>
        <!-- row -->

        <div class="container-fluid">
            <div class="row">
                <div class="col-12">


                    <div class="card">
                        <div class="card-body">
                            <div class="table-responsive">
                                <button class="btn mb-1 btn-primary" data-toggle="modal" data-target="#StaffAdminModel">Add
                                    Staff Admin</button>
                                <h4 class="card-title" style="text-align: -webkit-center;color: slategrey;">Staff Admins
                                </h4>

                                <table class="table table-striped table-bordered zero-configuration dataTable"
                                    id="example">
                                    <thead>
                                        <tr>
                                            <th>No.</th>
                                            <th>Name</th>
                                            <th>Email</th>
                                            <th>Password</th>
                                            <th>Contact</th>
                                            <th>Status</th>
                                            <th>Records</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $i = 1; ?>
                                        @foreach ($data as $item)
                                            <tr>
                                                <td>{{ $i }}</td>
                                                <td><a href="{{url('admin')}}/{{$item->id}}/staff" title="Click to View All Staff List" class="label label-primary">{{ $item->name }}</a></td>
                                                <td>{{ $item->email }}</td>
                                                <td>{{ $item->password }}</td>
                                                <td>{{ $item->contact }}</td>
                                                
                                                {{-- <td>{{ \Carbon\Carbon::parse($item->created_at)->format('m-d-Y') }}</td> --}}
                                                <td>
                                                    @if ($item->status == 1)
                                                        <a title="Click To Inactive/Activate Staff Admin" href="javascript:void(0)"
                                                            class="updateAdminStatus label mb-1  label-success"
                                                            staff_admin_id="{{ $item->id }}"
                                                            id="admin-{{ $item->id }}">Active</a>
                                                    @else
                                                        <a title="Click To Inactive/Activate Staff Admin" href="javascript:void(0)"
                                                            class="updateAdminStatus label mb-1  label-danger"
                                                            staff_admin_id="{{ $item->id }}"
                                                            id="admin-{{ $item->id }}">Inactive</a>
                                                    @endif
                                                </td>
                                                <td><a title="Click To view Reports" href="{{ url('staff-admin') }}/{{ $item->id }}/reports" class="label mb-1 label-primary">View Records</a></td>
                                                <td>

                                                    <a class="btn-danger btn-sm delete-confirm" data-toggle="tooltip"
                                                        href="{{ url('delete') }}/{{ $item->id }}/staff-admin"><i
                                                            class="fa fa-trash" title="Delete"
                                                            aria-hidden="true"></i></a>&nbsp;
                                                    <a class="btn-success btn-sm edit" id="{{ $item->id }}"
                                                        href="#"><i class="fa fa-edit" title="Edit"
                                                            aria-hidden="true"></i></a>&nbsp;
                                                </td>
                                            </tr>
                                            <?php $i++; ?>
                                        @endforeach
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <th>No.</th>
                                            <th>Name</th>
                                            <th>Email</th>
                                            <th>Password</th>
                                            <th>Contact</th>
                                            <th>Date</th>
                                            <th>Records</th>
                                            <th>Action</th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <!-- #/ container -->
    </div>
    </div>

    <!-- #/ container -->
    </div>
    <!--*************   Save Admin Model Starts   **************-->

    <div class="modal fade" id="StaffAdminModel" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered term" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Add New Staff Admin</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                            aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="javascript:void(0)" id="addStaffAdminForm" name="addStaffAdminForm"
                        class="form-horizontal" method="POST">
                        <div class="form-group">
                            <label>Name</label>
                            <input type="text" class="form-control" id="username" name="username"
                                placeholder="Admin Name">
                        </div>
                        <div class="form-group">
                            <label>Email</label>
                            <input type="email" class="form-control" id="email" name="email" placeholder="Email">
                        </div>
                        <div class="form-group">
                            <label>Contact</label>
                            <input type="number" class="form-control" id="contact" name="contact"
                                placeholder="Contact Number">
                        </div>
                        <div class="form-group">
                            <label>Password</label>
                            <input type="password" class="form-control" id="password" name="password"
                                placeholder="Password">
                        </div>
                        <div class="form-group">
                            <label>Confirm Password</label>
                            <input type="password" class="form-control" id="confirmPassword" name="confirmPassword"
                                placeholder="Confirm Password">
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-primary" id="btn-save">Save</button>
                </div>
            </div>
        </div>
    </div>
    <!--*************   Save Admin Model Ends   **************-->

    <!--*************   Update Admin Model Starts   **************-->
    <div class="modal fade" id="StaffAdminUpdateModel" tabindex="-1" role="dialog"
        aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered term" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Update Staff Admin</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                            aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="javascript:void(0)" id="addStaffAdminForm" name="addStaffAdminForm"
                        class="form-horizontal" method="POST">
                        <div class="form-group">
                            <label>Name</label>
                            <input type="text" class="form-control" id="username-update" name="username"
                                placeholder="Admin Name">
                        </div>
                        <div class="form-group">
                            <label>Email</label>
                            <input type="email" class="form-control" id="email-update" name="email"
                                placeholder="Email">
                        </div>
                        <div class="form-group">
                            <label>Password</label>
                            <input type="text" class="form-control" id="password-u" name="password-u"
                                placeholder="Password">
                        </div>
                        <div class="form-group">
                            <label>Contact</label>
                            <input type="number" class="form-control" id="contact-update" name="contact"
                                placeholder="Contact Number">
                            <input type="hidden" class="form-control" id="staffAdminId" name="staffAdminId" />
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-success" id="btn-update">Update</button>
                </div>
            </div>
        </div>
    </div>
    <!--*************   Save Admin Model Ends   **************-->
    <!--**********************************
                                        Content body end
                                    ***********************************-->
    <script>
        $(document).ready(function() {
            toastr.options.timeOut = 10000;
            @if (Session::has('error'))
                toastr.error('{{ Session::get('error') }}');
            @elseif (Session::has('success'))
                toastr.success('{{ Session::get('success') }}');
            @endif
        });
    </script>


    <script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/2.1.0/sweetalert.min.js"></script>
    <script type="text/javascript">
        toastr.options = {
            "closeButton": true,
            "debug": false,
            "newestOnTop": false,
            "progressBar": true,
            "positionClass": "toast-top-right",
            "preventDuplicates": true,
            "onclick": null,
            "showDuration": "300",
            "hideDuration": "1000",
            "timeOut": "1000",
            "extendedTimeOut": "1000",
            "showEasing": "swing",
            "hideEasing": "linear",
            "showMethod": "fadeIn",
            "hideMethod": "fadeOut"
        }
        $('.delete-confirm').click(function(event) {

            const url = $(this).attr('href');
            event.preventDefault();
            swal({
                    title: `Are you sure you want to delete this record?`,
                    text: "If you delete this, it will be gone forever.",
                    icon: "warning",
                    buttons: true,
                    dangerMode: true,
                })
                .then((willDelete) => {
                    if (willDelete) {
                        window.location.href = url;
                    }
                });
        });
        //save admin 
        $('body').on('click', '#btn-save', function(event) {
            if ($.trim($("#username").val()) == "" || $.trim($("#email").val()) == "" || $.trim($("#contact")
                    .val()) == "" || $.trim($("#password").val()) == "" || $.trim($("#confirmPassword").val()) ==
                "") {
                alert("Please Fill All Fields!");
            } else {
                if ($.trim($("#password").val()) != $.trim($("#confirmPassword").val())) {
                    alert("Please Fill Same Password!");
                } else {
                    var username = $("#username").val();
                    var email = $("#email").val();
                    var contact = $("#contact").val();
                    var password = $("#password").val();
                    $("#btn-save").html('Please Wait...');
                    $("#btn-save").attr("disabled", true);
                    // ajax
                    $.ajax({
                        type: "POST",
                        url: "{{ route('staff-admin.store') }}",
                        data: {
                            _token: "{{ csrf_token() }}",
                            username: username,
                            email: email,
                            contact: contact,
                            password: password,
                        },
                        dataType: 'json',
                        success: function(res) {
                            console.log(res)
                            $('#StaffAdminModel').modal('hide');
                            //window.location.reload();
                            toastr.success('Staff Admin Details Saved', 'Hi');
                            $("#btn-save").html('Submit');
                            $("#btn-save").attr("disabled", false);
                            window.setTimeout(function(){location.reload()},3000)
                        },
                        error: function(reject) {
                            if (reject.status === 422) {
                                var errors = $.parseJSON(reject.responseText);
                                $.each(errors, function(key, val) {
                                    $("#" + key + "_error").text(val[0]);

                                });
                                toastr.error('Email or Number already exists', 'Hi');
                                $("#btn-save").html('Submit');
                                $("#btn-save").attr("disabled", false);
                                $('#StaffAdminModel').modal('hide');
                            }
                        }
                    });
                }

            }
        });
        //update  admin
        $('body').on('click', '#btn-update', function(event) {
            if ($.trim($("#username-update").val()) == "" || $.trim($("#email-update").val()) == "" || $.trim($("#contact-update").val()) == "" || $.trim($("#password-u").val()) == "") {
                alert("Please Fill All Fields!");
            } else {
                var username = $("#username-update").val();
                var email = $("#email-update").val();
                var contact = $("#contact-update").val();
                var password = $("#password-u").val();
                var id = $("#staffAdminId").val();
                $("#btn-update").html('Please Wait...');
                $("#btn-update").attr("disabled", true);
                // ajax
                $.ajax({
                    type: "POST",
                    url: "{{ route('staff-admin.update') }}",
                    data: {
                        _token: "{{ csrf_token() }}",
                        username: username,
                        email: email,
                        contact: contact,
                        password: password,
                        id: id,
                    },
                    dataType: 'json',
                    success: function(res) {
                        console.log(res)
                        $('#StaffAdminUpdateModel').modal('hide');
                        //window.location.reload();
                        toastr.success('Staff Admin Details Updated', 'Hi');
                        $("#btn-update").html('Update');
                        $("#btn-update").attr("disabled", false);
                        window.setTimeout(function(){location.reload()},3000)
                    },
                    error: function(reject) {
                        if (reject.status === 422) {
                            var errors = $.parseJSON(reject.responseText);
                            $.each(errors, function(key, val) {
                                $("#" + key + "_error").text(val[0]);
                            });
                            toastr.error('Email or Number already exists', 'Hi');
                            $("#btn-update").html('Submit');
                            $("#btn-update").attr("disabled", false);
                            $('#StaffAdminUpdateModel').modal('hide');
                        }
                    }
                });
            }
        });

        $(document).ready(function() {
            $('#example').DataTable({
                dom: 'Bfrtip',
                buttons: [
                    'copyHtml5',
                    'excelHtml5',
                    'csvHtml5',
                    'pdfHtml5'
                ]
            });
        });

        //update Staff Admin Status Attruibute status
        $(".updateAdminStatus").click(function() {
            var status = $(this).text();
            var staff_admin_id = $(this).attr("staff_admin_id");
            $.ajax({
                type: 'post',
                url: 'staff-admin-status',
                data: {
                    status: status,
                    staff_admin_id: staff_admin_id,
                    _token: '{{ csrf_token() }}'
                },
                success: function(resp) {
                    if (resp['status'] == 0) {
                        $("#admin-" + staff_admin_id).html("Inactive");
                        $("#admin-" + staff_admin_id).removeClass('label-success');
                        $("#admin-" + staff_admin_id).addClass('label-danger');
                    } else if (resp['status'] == 1) {
                        $("#admin-" + staff_admin_id).html("Active");
                        $("#admin-" + staff_admin_id).removeClass('label-danger');
                        $("#admin-" + staff_admin_id).addClass('label-success');
                    }
                },
                error: function() {
                    alert("error");
                }
            });

        });

        $(document).on('click', '.edit', function() {
            var id = $(this).attr("id");
            $('#form_output').html('');
            $.ajax({
                url: "{{ route('staff-admin.fetchdata') }}",
                method: 'get',
                data: {
                    id: id
                },
                dataType: 'json',
                success: function(data) {
                    $('#username-update').val(data.name);
                    $('#email-update').val(data.email);
                    $('#contact-update').val(data.contact);
                    $('#password-u').val(data.password);
                    $('#staffAdminId').val(id);
                    $('#StaffAdminUpdateModel').modal('show');
                }
            })
        });
    </script>
@endsection
