@extends('layouts.main-layout')

@section('content')
    <!--**********************************
                                        Content body start
                                    ***********************************-->
    <div class="content-body">

        <div class="row page-titles mx-0">
            <div class="col p-md-0">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ url('/') }}">Dashboard</a></li>
                    <li class="breadcrumb-item active"><a href="">Record Detail</a></li>
                </ol>
            </div>
        </div>
        <!-- row -->

        <div class="container-fluid">
            <div class="row">
                <div class="col-12">


                    <div class="card">
                        <div class="card-body">
                            
                                <h1 style="text-align: -webkit-center;">SAFETY H.I.T. LIST</h1>
                                </br>
                                <div class="basic-form">
                                    <form method="post" action="{{url('save-record')}}">
                                        @csrf
                                        <div class="form-row">
                                            <div class="form-group col-md-6">
                                                <label>Company Name</label>
                                                <input type="text" class="form-control input-default" name="c_name" value="{{$data->company}}" placeholder="Company Name" >
                                                <input type="hidden" name="record_id" value="{{$data->id}}"/>
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>Staff Name</label>
                                                <select name="staff_name" class="form-control" required>
                                                    <option value="">Select Staff</option>
                                                    @foreach($staff as $Staff)
                                                    <option value="{{$Staff->id}}" {{ $Staff->name === $data->staff_name ? "Selected" : "" }}>{{$Staff->name}}</option>
                                                    @endforeach
                                                </select>
                                                <!--<input type="text" class="form-control input-default" name="staff_name" value="{{$data->staff_name}}" placeholder="Staff Name">-->
                                            </div>
                                        </div>
                                        <div class="form-row">
                                            <div class="form-group col-md-6">
                                                <label>Builder Name</label>
                                                <select name="builder_name" class="form-control" required>
                                                    <option value="">Select Builder</option>
                                                    @foreach($builder as $Builder)
                                                    <option value="{{$Builder->id}}" {{ $Builder->name === $data->builder_name ? "Selected" : "" }}>{{$Builder->name}}</option>
                                                    @endforeach
                                                </select>    
                                                
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>Location</label>
                                                <input type="text" class="form-control input-default" name="location" value="{{$data->location}}" placeholder="Location 1234 Main St" >
                                            </div>
                                        </div>
                                        </br>
                                        <div class="form-row">
                                            <label class="card-title">Pre Start Checklist</label>
                                        </div>
                                        <div class="form-group row">
                                            <div class="col-md-3">
                                                <div class="form-check">
                                                    <input type="checkbox" class="form-check-input" name="site_signage" @if($precheckList->site_signage=='1') value="1" checked @else value="0" @endif/>
                                                    <label>Construction Site Signage</label>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-check">
                                                    <input type="checkbox" class="form-check-input" name="sub_cont_drient" @if($precheckList->sub_cont_drient=='1') checked @endif/>
                                                    <label>Sub-Cont. Orient</label>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-check">
                                                    <input type="checkbox" class="form-check-input" name="public_protection" @if($precheckList->public_protection=='1') checked @endif />
                                                    <label>Public Protection</label>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-check">
                                                    <input type="checkbox" class="form-check-input" name="contact_numbers" @if($precheckList->contact_numbers=='1') checked @endif />
                                                    <label>Contact Numbers</label>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-check">
                                                    <input type="checkbox" class="form-check-input" name="w_safety" @if($precheckList->w_safety=='1') value="1" checked @else value="0" @endif />
                                                    <label>Workplace Safety Act+Reg</label>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-check">
                                                    <input type="checkbox" class="form-check-input" name="msds_sheets" @if($precheckList->msds_sheets=='1') checked @endif />
                                                    <label>MSDS Sheets</label>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-check">
                                                    <input type="checkbox" class="form-check-input" name="communication_device" @if($precheckList->communication_device=='1') checked @endif />
                                                    <label>Communication Device</label>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-check">
                                                    <input type="checkbox" class="form-check-input" name="fire_extinguisher" @if($precheckList->fire_extinguisher=='1') checked @endif />
                                                    <label>Fire Extinguisher</label>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-check">
                                                    <input type="checkbox" class="form-check-input" name="ad_supply_eyewash" @if($precheckList->ad_supply_eyewash=='1') checked @endif />
                                                    <label>First Aid Supply/Eyewash</label>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-check">
                                                    <input type="checkbox" class="form-check-input" name="washroom_facility" @if($precheckList->washroom_facility=='1') checked @endif />
                                                    <label>Washroom Facility</label>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-check">
                                                    <input type="checkbox" class="form-check-input" name="utility_clearence" @if($precheckList->utility_clearence=='1') checked @endif />
                                                    <label>Exc. Permit/Utility Clearence</label>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-check">
                                                    <input type="checkbox" class="form-check-input" name="other" @if($precheckList->other=='1') checked @endif />
                                                    <label>Others</label>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        </br>
                                        <div class="form-row">
                                            <label class="card-title">Inspection Checklist</label>
                                        </div>
                                        <div class="form-group row">
                                            <div class="col-md-3">
                                                <div class="form-check">
                                                    <input type="checkbox" class="form-check-input" name="i_emergency_response" @if($inspectionList->emergency_response=='1') checked @endif />
                                                    <label>Emergency Response</label>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-check">
                                                    <input type="checkbox" class="form-check-input" name="i_ppe" @if($inspectionList->ppe=='1') checked @endif />
                                                    <label>PPE</label>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-check">
                                                    <input type="checkbox" class="form-check-input" name="i_tools" @if($inspectionList->tools=='1') checked @endif />
                                                    <label>Tools+Equipment</label>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-check">
                                                    <input type="checkbox" class="form-check-input" name="i_first_aid_kit" @if($inspectionList->first_aid_kit=='1') checked @endif />
                                                    <label>First Aid Kit</label>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-check">
                                                    <input type="checkbox" class="form-check-input" name="i_fire_extinguisher" @if($inspectionList->fire_extinguisher=='1') checked @endif />
                                                    <label>Fire Extinguisher</label>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-check">
                                                    <input type="checkbox" class="form-check-input" name="i_housekeeping" @if($inspectionList->housekeeping=='1') checked @endif />
                                                    <label>HouseKeeping</label>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-check">
                                                    <input type="checkbox" class="form-check-input" name="i_ladders_walkway" @if($inspectionList->ladders_walkway=='1') checked @endif />
                                                    <label>Ladders/Walkways</label>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-check">
                                                    <input type="checkbox" class="form-check-input" name="i_signage" @if($inspectionList->signage=='1') checked @endif />
                                                    <label>Signage</label>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-check">
                                                    <input type="checkbox" class="form-check-input" name="i_guardrail" @if($inspectionList->guardrail=='1') checked @endif />
                                                    <label>Guardrail</label>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-check">
                                                    <input type="checkbox" class="form-check-input" name="i_lockout_tagout" @if($inspectionList->lockout_tagout=='1') checked @endif />
                                                    <label>Lockout/Tagout</label>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-check">
                                                    <input type="checkbox" class="form-check-input" name="i_msds" @if($inspectionList->msds=='1') checked @endif />
                                                    <label>WHMIS/MSDS</label>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-check">
                                                    <input type="checkbox" class="form-check-input" name="i_utilities" @if($inspectionList->utilities=='1') checked @endif />
                                                    <label>Utilities(Marked)</label>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-check">
                                                    <input type="checkbox" class="form-check-input" name="i_electrical_panel" @if($inspectionList->electrical_panel=='1') checked @endif />
                                                    <label>Electical Panel</label>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-check">
                                                    <input type="checkbox" class="form-check-input" name="i_access_egress" @if($inspectionList->access_egress=='1') checked @endif />
                                                    <label>Access/Egress</label>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-check">
                                                    <input type="checkbox" class="form-check-input" name="i_fall_protection" @if($inspectionList->fall_protection=='1') checked @endif />
                                                    <label>Heights/Fall Protection</label>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-check">
                                                    <input type="checkbox" class="form-check-input" name="i_other" @if($inspectionList->other=='1') checked @endif />
                                                    <label>Others</label>
                                                </div>
                                            </div>
                                        </div>
                                        
                                            <h3 style="text-align: -webkit-center;">Please categorized and rank the severity (1-5) + probability (A-D) of the hazard</h3>
                                            <h4 style="text-align: -webkit-center;">Then Identify plans to eliminate or control the hazard.</h4>
                                            <div class="form-row">
                                                    <div class="form-group col-md-4">
                                                      <h6>1-Immediate Danger, (death disaster)</h6>
                                                      <h6>4-Negligible, (first aid or less)</h6>
                                                      <h6>A-Probable, (immediately or soon)</h6>
                                                      <h6>C-Remote, (could at some point)</h6>
                                                    </div>
                                                    <div class="form-group col-md-4">
                                                       <h6>2-Serious injury, (major injury, damage)</h6>
                                                       <h6>5-Not applicable</h6>
                                                       <h6>B-Reasonably Probable, (eventually)</h6>
                                                      <h6>D-Extremely Remote, (not likely)</h6>
                                                    </div>
                                                    <div class="form-group col-md-4">
                                                       <h6>3-Minor, (non serious injury, damage)</h6> 
                                                    </div>
                                            </div>
                                        <div class="form-row">
                                            <label class="card-title">Hazard</label>
                                        </div>
                                        <div class="add_row">
                                        @if($hazard=='[]')
                                        <div class="form-row">
                                            <div class="form-group col-md-9">
                                                <label>Hazard</label>
                                                     <input type="text" class="form-control input-default" name="hazard_detail[]"  placeholder="Hazard" >   
                                                    </div>
                                                    <div class="form-group col-md-1">
                                                        <label>Severity</label>
                                                        <select name="severity[]" class="form-control">
                                                            
                                                            <option value="1">1</option>
                                                            <option value="2">2</option>
                                                            <option value="3">3</option>
                                                            <option value="4">4</option>
                                                            <option value="5">5</option>
                                                        </select>
                                                    </div>
                                                    <div class="form-group col-md-1">
                                                        <label>Hazard probability</label>
                                                        <select name="hazard[]" class="form-control">
                                                            
                                                            <option value="A">A</option>
                                                            <option value="B">B</option>
                                                            <option value="C">C</option>
                                                            <option value="D">D</option>
                                                        </select>
                                                    </div>
                                                    <div class="form-group col-md-1">
                                                        <label></label>
                                                        <a href="javascript:void(0);" class="add_button btn btn-primary form-control" title="Add field" style="margin: 7px;padding: 12px;border-radius:5px;">Add</a>
                                                    </div>
                                                </div>
                                        @endif
                                        
                                            <?php $i=1;?>
                                        @foreach($hazard as $selecthazard)
                                            @if($i==1)
                                                <div class="form-row">
                                                    <div class="form-group col-md-9">
                                                       <label>Hazard</label>
                                                     <input type="text" class="form-control input-default" name="hazard_detail[]" value="{{$selecthazard->detail}}" placeholder="Hazard" >   
                                                    </div>
                                                    <div class="form-group col-md-1">
                                                        <label>Severity</label>
                                                        <select name="severity[]" class="form-control">
                                                            
                                                            <option value="1" {{  $selecthazard->rank === "1" ? "Selected" : "" }}>1</option>
                                                            <option value="2" {{  $selecthazard->rank === "2" ? "Selected" : "" }}>2</option>
                                                            <option value="3" {{  $selecthazard->rank === "3" ? "Selected" : "" }}>3</option>
                                                            <option value="4" {{  $selecthazard->rank === "4" ? "Selected" : "" }}>4</option>
                                                            <option value="5" {{  $selecthazard->rank === "5" ? "Selected" : "" }}>5</option>
                                                        </select>
                                                    </div>
                                                    <div class="form-group col-md-1">
                                                        <label>Hazard probability</label>
                                                        <select name="hazard[]" class="form-control">
                                                            
                                                            <option value="A" {{  $selecthazard->hazard === "A" ? "Selected" : "" }}>A</option>
                                                            <option value="B" {{  $selecthazard->hazard === "B" ? "Selected" : "" }}>B</option>
                                                            <option value="C" {{  $selecthazard->hazard === "C" ? "Selected" : "" }}>C</option>
                                                            <option value="D" {{  $selecthazard->hazard === "D" ? "Selected" : "" }}>D</option>
                                                        </select>
                                                    </div>
                                                    <div class="form-group col-md-1">
                                                        <label></label>
                                                        <a href="javascript:void(0);" class="add_button btn btn-primary form-control" title="Add field" style="margin: 7px;padding: 12px;border-radius:5px;">Add</a>
                                                    </div>
                                                </div>
                                            @else
                                                <div class="form-row">
                                                    <div class="form-group col-md-9">
                                                        <label>Hazard</label>
                                                     <input type="text" class="form-control input-default" name="hazard_detail[]" value="{{$selecthazard->detail}}" placeholder="Hazard" >   
                                                    </div>
                                                    <div class="form-group col-md-1">
                                                        <label>Severity</label>
                                                        <select name="severity[]" class="form-control">
                                                            
                                                            <option value="1" {{  $selecthazard->rank === "1" ? "Selected" : "" }}>1</option>
                                                            <option value="2" {{  $selecthazard->rank === "2" ? "Selected" : "" }}>2</option>
                                                            <option value="3" {{  $selecthazard->rank === "3" ? "Selected" : "" }}>3</option>
                                                            <option value="4" {{  $selecthazard->rank === "4" ? "Selected" : "" }}>4</option>
                                                            <option value="5" {{  $selecthazard->rank === "5" ? "Selected" : "" }}>5</option>
                                                        </select>
                                                    </div>
                                                    <div class="form-group col-md-1">
                                                        <label>Hazard probability</label>
                                                        <select name="hazard[]" class="form-control">
                                                            
                                                            <option value="A" {{  $selecthazard->hazard === "A" ? "Selected" : "" }}>A</option>
                                                            <option value="B" {{  $selecthazard->hazard === "B" ? "Selected" : "" }}>B</option>
                                                            <option value="C" {{  $selecthazard->hazard === "C" ? "Selected" : "" }}>C</option>
                                                            <option value="D" {{  $selecthazard->hazard === "D" ? "Selected" : "" }}>D</option>
                                                        </select>
                                                    </div>
                                                    <div class="form-group col-md-1">
                                                        <label></label>
                                                        <a href="javascript:void(0);" class="remove_button btn btn-danger form-control" title="Add field" style="margin: 7px;padding: 12px;border-radius:5px;">Remove</a>
                                                    </div>
                                                </div>
                                            @endif
                                            <?php $i++; ?>
                                        @endforeach    
                                        </div>
                                        <div class="form-row">
                                            <label class="card-title">Staff on site</label>
                                        </div>
                                        <div class="add_row_staff">
                                            @if($onSiteStaff == '[]')
                                                <div class="form-row">
                                                    <div class="form-group col-md-6">
                                                    <input type="text" class="form-control input-default" name="staffonsite[]" >
                                                    </div>
                                                    <div class="form-group col-md-2">
                                                        <a href="javascript:void(0);" class="add_button_for_staff btn btn-primary form-control" title="Add field" style="margin: 0px;padding: 12px;border-radius:5px;">Add</a>
                                                    </div>
                                                </div>
                                            @else
                                                <?php $k=1; ?>
                                                @foreach($onSiteStaff as $siteStaff)
                                                @if($k==1)
                                                    <div class="form-row">
                                                        <div class="form-group col-md-6">
                                                        <input type="text" class="form-control input-default" name="staffonsite[]" value="{{$siteStaff->detail}}">
                                                        </div>
                                                        <div class="form-group col-md-2">
                                                            <a href="javascript:void(0);" class="add_button_for_staff btn btn-primary form-control" title="Add field" style="margin: 0px;padding: 12px;border-radius:5px;">Add</a>
                                                        </div>
                                                    </div>
                                                @else
                                                <div class="form-row">
                                                        <div class="form-group col-md-6">
                                                        <input type="text" class="form-control input-default" name="staffonsite[]" value="{{$siteStaff->detail}}">
                                                        </div>
                                                        <div class="form-group col-md-2">
                                                            <a href="javascript:void(0);" class="remove_button_for_staff btn btn-danger form-control" title="Remove field" style="margin: 0px;padding: 12px;border-radius:5px;">Remove</a>
                                                        </div>
                                                    </div>
                                                @endif
                                                <?php $k++; ?>
                                                @endforeach
                                            @endif
                                            
                                        </div>    
                                        <div class="row">
                                            <div class="col-12">
                                                <label class="card-title">Images</label>
                                                <div class="row">
                                                    @foreach($images as $item)
                                                    <div class="col-md-6 col-lg-3">
                                                        <div class="card">
                                                            <a href="{{asset('site_images')}}/{{$item->image}}" target="_blank"><img class="img-fluid" src="{{asset('site_images')}}/{{$item->image}}" alt=""style="width: 100%;height: 12vw;object-fit: cover;"></a>
                                                            <div class="card-footer">
                                                                <button type="button" class="btn mb-1 btn-success d-inline update-image btn-xs" id="{{$item->id}}">Update<span class="btn-icon-right"><i class="fa fa-upload"></i></span>
                                                                <button type="button" class="btn mb-1 btn-danger float-right delete-image btn-xs" value="{{$item->id}}">Remove<span class="btn-icon-right"><i class="fa fa-close"></i></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    @endforeach
                                                    <!-- End Col -->
                                                    
                                                    <!-- End Col -->
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="row">
                                            <div class="col-12">
                                                <label class="card-title">Add Another Image</label>
                                                <button type="button" class="btn mb-1 btn-success d-inline upload-image" >Upload New Image<span class="btn-icon-right"><i class="fa fa-upload"></i></span></button>
                                                
                                            </div>    
                                        </div>
                                        @if($data->damage)
                                        <div class="form-row">
                                            <div class="form-group col-md-6">
                                                <label>Damages</label>
                                                <input type="text" class="form-control input-default" name="damage" value="{{$data->damage}}" placeholder="Damage" >
                                            </div>
                                        </div>
                                        @endif
                                        </br>
                                        <center><button type="submit" class="btn btn-primary">Save Details</button></center>
                                    </form>
                                </div>
                                
                            
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <!-- #/ container -->
    </div>
    </div>
 <!--*************   Update Image Model Starts   **************-->
    <div class="modal fade" id="StaffAdminUpdateModel" tabindex="-1" role="dialog"
        aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered term" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Update Image</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                            aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="javascript:void(0)" id="addStaffAdminForm" name="addStaffAdminForm"
                        class="form-horizontal" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="form-group">
                            <input type="file" class="form-control" id="contact-update" name="image"
                                placeholder="Selcet Image">
                            <input type="hidden" class="form-control" id="imageID" name="imageID" />
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-success" id="btn-update">Update</button>
                </div>
            </div>
        </div>
    </div>
    <!--*************   Update Image Model Ends   **************-->
    
    <!--*************   Update Image Model Starts   **************-->
    <div class="modal fade" id="ImageUploadModel" tabindex="-1" role="dialog"
        aria-labelledby="ImageUploadModel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered term" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Update Image</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                            aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="javascript:void(0)" id="ImageUploadForm" name="ImageUploadForm"
                        class="form-horizontal" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="form-group">
                            <input type="file" class="form-control" id="contact-update" name="image"
                                placeholder="Selcet Image">
                            <input type="hidden" class="form-control" id="recordID" name="recordID" value="{{$data->id}}" />
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-success" id="btn-upload">Upload</button>
                </div>
            </div>
        </div>
    </div>
    <!--*************   Update Image Model Ends   **************-->
    <!-- #/ container -->
    </div>

    <!--**********************************
                                        Content body end
                                    ***********************************-->
    <script>
        $(document).ready(function() {
            toastr.options.timeOut = 10000;
            @if (Session::has('error'))
                toastr.error('{{ Session::get('error') }}');
            @elseif (Session::has('success'))
                toastr.success('{{ Session::get('success') }}');
            @endif
        });
    </script>


    <script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/2.1.0/sweetalert.min.js"></script>
    <script type="text/javascript">
        toastr.options = {
            "closeButton": true,
            "debug": false,
            "newestOnTop": false,
            "progressBar": true,
            "positionClass": "toast-top-right",
            "preventDuplicates": true,
            "onclick": null,
            "showDuration": "300",
            "hideDuration": "1000",
            "timeOut": "1000",
            "extendedTimeOut": "1000",
            "showEasing": "swing",
            "hideEasing": "linear",
            "showMethod": "fadeIn",
            "hideMethod": "fadeOut"
        }
        
        $('.delete-image').click(function(event) {

            const url = $(this).attr('href');
            var imgID = $(this).val();
            event.preventDefault();
            swal({
                    title: `Are you sure you want to delete this record?`,
                    text: "If you delete this, it will be gone forever.",
                    icon: "warning",
                    buttons: true,
                    dangerMode: true,
                })
                .then((willDelete) => {
                    if (willDelete) {
                         $.ajax({
                             url: "{{ url('record-image-delete') }}/"+imgID,
                             success: function(res) {
                                 swal({
                                    title: `Deleted Successfully`,
                                    text: "Image Successfully Removed",
                                    icon: "success",
                                    buttons: "OK",
                                }).then((confirmed)=>{
                                    window.location.reload()
                                })
                             }
                         });
                    }
                });
        });
        
        var maxField = 10; //Input fields increment limitation
        var maxFieldForStaff = 5; //Input fields increment limitation
        var addButton = $('.add_button'); //Add button selector
        var addStaffButton = $('.add_button_for_staff'); //Add button selector
        var wrapper = $('.add_row'); //Input field wrapper
        var wrapperforstaff = $('.add_row_staff');
        
        //staff on site
        var staffFieldHTML = '<div class="form-row"><div class="form-group col-md-6"><input type="text" class="form-control input-default" name="staffonsite[]" ></div><div class="form-group col-md-2"><a href="javascript:void(0);" class="remove_button_for_staff btn btn-danger form-control" title="Remove field" style="margin: 0px;padding: 12px;border-radius:5px;">Remove</a></div></div>'; //New input field html 
        var y = 1; //Initial field counter is 1
        //Once add button is clicked
        $(addStaffButton).click(function() {
            //Check maximum number of input fields
            if (y < maxFieldForStaff) {
                y++; //Increment field counter
                $(wrapperforstaff).append(staffFieldHTML); //Add field html
            }
        });
        $(wrapperforstaff).on('click', '.remove_button_for_staff', function(e) {
            e.preventDefault();
            $(this).parent('div').parent('div').remove(); //Remove field html
            y--; //Decrement field counter
        });
        //staff on site
        
                                        
        var fieldHTML = '<div class="form-row"><div class="form-group col-md-9"><label>Hazard</label><input type="text" class="form-control input-default" name="hazard_detail[]"  placeholder="Hazard"></div><div class="form-group col-md-1"><label>Severity</label><select name="severity[]" class="form-control"><option value="1">1</option><option value="2">2</option><option value="3">3</option><option value="4">4</option><option value="5">5</option></select></div><div class="form-group col-md-1"><label>Hazard probability</label><select name="hazard[]" class="form-control"><option value="A">A</option><option value="B">B</option><option value="C">C</option><option value="D">D</option></select></div><div class="form-group col-md-1"><label></label><a href="javascript:void(0);" class="remove_button btn btn-danger form-control" title="Add field" style="margin: 7px;padding: 12px;border-radius:5px;">Remove</a></div></div>'; //New input field html 
        var x = 1; //Initial field counter is 1
        //Once add button is clicked
        $(addButton).click(function() {
            //Check maximum number of input fields
            if (x < maxField) {
                x++; //Increment field counter
                $(wrapper).append(fieldHTML); //Add field html
            }
        });
        //Once remove button is clicked
        $(wrapper).on('click', '.remove_button', function(e) {
            e.preventDefault();
            $(this).parent('div').parent('div').remove(); //Remove field html
            x--; //Decrement field counter
        });
        
        $(document).on('click', '.update-image', function() {
            var id = $(this).attr("id");
                    $('#imageID').val(id);
                    $('#StaffAdminUpdateModel').modal('show');
                
           
        });
        
         $(document).on('click', '.upload-image', function() {
                    $('#ImageUploadModel').modal('show');
        });
        
        $('body').on('click', '#btn-update', function(event) {
            
                var imageID = $("#imageID").val();
                var formData = new FormData($('#addStaffAdminForm')[0]);
                $("#btn-update").html('Please Wait...');
                $("#btn-update").attr("disabled", true);
                // ajax
                $.ajax({
                    type: "POST",
                    url: "{{ url('record-image-update') }}/"+imageID,
                    data: formData,
                    contentType: false,
                    processData: false,
                    success: function(res) {
                        if(res.status == 200)
                        {
                            console.log(res)
                        $('#StaffAdminUpdateModel').modal('hide');
                        //window.location.reload();
                        toastr.success('Staff Admin Details Updated', 'Hi');
                        $("#btn-update").html('Update');
                        $("#btn-update").attr("disabled", false);
                        window.setTimeout(function(){location.reload()},3000)
                        }
                        else
                        {
                            toastr.error('Error', 'Hi');
                            $("#btn-update").html('Submit');
                            $("#btn-update").attr("disabled", false);
                            $('#StaffAdminUpdateModel').modal('hide');
                        }
                        
                    },
                    error: function(reject) {
                        if (reject.status === 422) {
                            var errors = $.parseJSON(reject.responseText);
                            $.each(errors, function(key, val) {
                                $("#" + key + "_error").text(val[0]);
                            });
                            toastr.error('Email or Number already exists', 'Hi');
                            $("#btn-update").html('Submit');
                            $("#btn-update").attr("disabled", false);
                            $('#StaffAdminUpdateModel').modal('hide');
                        }
                    }
                });
            
        });
        
        
        $('body').on('click', '#btn-upload', function(event) {
            
                var recordID = $("#recordID").val();
                var formData = new FormData($('#ImageUploadForm')[0]);
                $("#btn-upload").html('Please Wait...');
                $("#btn-upload").attr("disabled", true);
                // ajax
                $.ajax({
                    type: "POST",
                    url: "{{ url('record-image-upload') }}/"+recordID,
                    data: formData,
                    contentType: false,
                    processData: false,
                    success: function(res) {
                        if(res.status == 200)
                        {
                            console.log(res)
                        $('#ImageUploadModel').modal('hide');
                        //window.location.reload();
                        toastr.success('Image Uploaded', 'Hi');
                        $("#btn-upload").html('Update');
                        $("#btn-upload").attr("disabled", false);
                        window.setTimeout(function(){location.reload()},3000)
                        }
                        else
                        {
                            toastr.error('Error', 'Hi');
                            $("#btn-upload").html('Submit');
                            $("#btn-upload").attr("disabled", false);
                            $('#ImageUploadModel').modal('hide');
                        }
                        
                    },
                    error: function(reject) {
                        if (reject.status === 422) {
                            var errors = $.parseJSON(reject.responseText);
                            $.each(errors, function(key, val) {
                                $("#" + key + "_error").text(val[0]);
                            });
                            toastr.error('Error', 'Hi');
                            $("#btn-upload").html('Submit');
                            $("#btn-upload").attr("disabled", false);
                            $('#ImageUploadModel').modal('hide');
                        }
                    }
                });
            
        });
        
       
              
    </script>
@endsection
