<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Staff;
use App\Models\StaffAdmin;
use App\Models\BuilderAdmin;
use App\Models\Builder;
use Illuminate\Support\Facades\Validator;
use Carbon\Carbon;

class StaffAdminController extends Controller
{
    public function staffList(Request $request)
    {
        $validateUser = Validator::make($request->all(), 
            [
                'id' => 'required',
            ]);
        if($validateUser->fails()){
                return response()->json([
                    'status' => false,
                    
                    'message' => $validateUser->errors()->first()
                ], 401);
            }
        $data = Staff::select('staff.id','staff.name','staff.created_at','staff.email','staff.contact','staff.company','staff.location','staff_admins.name as adminName','staff_admins.id as staffAdminID')->join('staff_admins','staff_admins.id','=','staff.admin_id')->where('staff_admins.id',$request->id)->get();
        $finalData = array();
        foreach($data as $test)
        {
            $k['id'] = $test->id;
            $k['name'] = $test->name;
            $k['email'] = $test->email;
            $k['contact'] = $test->contact;
            $k['company'] = $test->company;
            $k['location'] = $test->location;
            $k['adminName'] = $test->adminName;
            $k['staffAdminID'] = $test->staffAdminID;
            $k['date'] = Carbon::parse($test->created_at)->format('d-m-Y');
            $k['time'] = Carbon::parse($test->created_at)->format('h:i A');
            $finalData[] = $k;
        }
        
        if($finalData == '[]')
        {
            return response()->json([
                'status' => false,
                'message' => 'Empty Data',
                'data'=>$finalData,
            ], 200);    
        }
        return response()->json([
                'status' => true,
                'message' => 'success',
                'data'=>$finalData,
            ], 200);    
    }
    
    public function staffDeleteTest(Request $request)
    {
        $validateUser = Validator::make($request->all(), 
            [
                
                'staff_id' => 'required|exists:staff,id',
                
            ]);
        if($validateUser->fails()){
                return response()->json([
                    'status' => false,
                    
                    'message' => $validateUser->errors()->first()
                ], 401);
            }
        $staff = Staff::where('id',$request->staff_id)->delete();    
        return response()->json([
                'status' => true,
                'message' => 'success',
                'data'=>'',
            ], 200);    
    }
    
    public function checkDate(Request $request)
    {
        $expirationDate = Carbon::parse('10-03-2025'); // Replace $yourDate with your actual date variable
//return Carbon::now()->diffInDays($expirationDate);
        // Check if the current date is more than seven days after the expiration date
        if (Carbon::now()->diffInDays($expirationDate) > 3) {
            // Date has expired after seven days
            // Add your logic here
            // For example, you can return a response or perform some a ction
            return response()->json(['status' => true,'message' => false], 200);
        } else {
            // Date is still valid
            // Add your logic for valid date
            return response()->json(['status' => true,'message' => true], 200);
        }
    }
    
    public function staffCreate(Request $request)
    {
        $validateUser = Validator::make($request->all(), 
            [
                'staff_admin_id' => 'required|exists:staff_admins,id',
                'name' => 'required',
                'company' => 'required',
                'email' => 'required|unique:staff|unique:staff_admins|unique:builder_admins|unique:builders',
                'contact' => 'required|unique:staff|unique:staff_admins|unique:builder_admins|unique:builders',
                'location' => 'required',
                'password' => 'required',
                'confirm_password' => 'required',
            ]);
        if($validateUser->fails()){
                return response()->json([
                    'status' => false,
                    
                    'message' => $validateUser->errors()->first()
                ], 401);
            }
        if($request->password != $request->confirm_password)
        {
            return response()->json([
                    'status' => false,
                    'message' => 'Password Not Matched',
                    'errors' => "Password Not Matched"
                ], 401);
        }
        $data = new Staff;
        $data->name = $request->name;
        $data->email = $request->email;
        $data->contact = $request->contact;
        $data->company = $request->company;
        $data->location = $request->location;
        $data->password = $request->password;
        $data->admin_id = $request->staff_admin_id;
        $data->status = 0;
        $data->save();
        return response()->json([
                'status' => true,
                'message' => 'success',
                'data'=>'',
            ], 200);
    }
    
    public function staffCreateTest(Request $request)
    {
        $validateUser = Validator::make($request->all(), 
            [
                
                'name' => 'required',
                'email' => 'required|unique:staff|unique:staff_admins|unique:builder_admins|unique:builders',
                'contact' => 'required|unique:staff|unique:staff_admins|unique:builder_admins|unique:builders',
                'password' => 'required',
            ]);
        if($validateUser->fails()){
                return response()->json([
                    'status' => false,
                    
                    'message' => $validateUser->errors()->first()
                ], 401);
            }
        
        $data = new Staff;
        $data->name = $request->name;
        $data->email = $request->email;
        $data->contact = $request->contact;
        $data->company = "company.co";
        $data->location = 'London';
        $data->password = $request->password;
        $data->admin_id = 2;
        $data->status = 1;
        $data->save();
        
        
        $staff = Staff::where('id',$data->id)->first();
        if($staff)
        {
            $check = Staff::where('email',$request->email)->where('password',$request->password)->where('status',1)->first();
            if(!$check)
            {
                return response()->json([
                    'status' => false,
                    'message' => 'Contact & Password does not match with our record.',
                ], 401);
            }
            $admin = $check->admin_id;
            $adminName = StaffAdmin::where('id',$admin)->first();
            return response()->json([
                'status' => true,
                'message' => 'Logged In Successfully',
                'id'=>$check->id,
                'type'=>'staff',
                'name'=>$check->name,
                'email'=>$check->email,
                'contact'=>$check->contact,
                'company'=>$check->company,
                'location'=>$check->location,
                'staffAdmin_id'=>$check->admin_id,
                'staffAdmin'=>$adminName->name,
                
            ], 200);
        }
        return response()->json([
                'status' => true,
                'message' => 'success',
                'data'=>'',
            ], 200);
    }
}
