<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Staff;
use App\Models\StaffAdmin;
use App\Models\BuilderAdmin;
use App\Models\Builder;
use Illuminate\Support\Facades\Validator;

class LoginController extends Controller
{
    public function login(Request $request)
    {
        $validateUser = Validator::make($request->all(), 
            [
                'email' => 'required',
                'password' => 'required',
            ]);
        if($validateUser->fails()){
                return response()->json([
                    'status' => false,
                    
                    'message' => $validateUser->errors()->first()
                ], 401);
            }
        $staff = Staff::where('email',$request->email)->first();
        if($staff)
        {
            $check = Staff::where('email',$request->email)->where('password',$request->password)->where('status',1)->first();
            if(!$check)
            {
                return response()->json([
                    'status' => false,
                    'message' => 'Contact & Password does not match with our record.',
                ], 401);
            }
            $admin = $check->admin_id;
            $adminName = StaffAdmin::where('id',$admin)->first();
            return response()->json([
                'status' => true,
                'message' => 'Logged In Successfully',
                'id'=>$check->id,
                'type'=>'staff',
                'name'=>$check->name,
                'email'=>$check->email,
                'contact'=>$check->contact,
                'company'=>$check->company,
                'location'=>$check->location,
                'staffAdmin_id'=>$check->admin_id,
                'staffAdmin'=>$adminName->name,
                
            ], 200);
        }
        
        $staffAdmin = StaffAdmin::where('email',$request->email)->first();
        if($staffAdmin)
        {
            $check = StaffAdmin::where('email',$request->email)->where('password',$request->password)->where('status',1)->first();
            if(!$check)
            {
                return response()->json([
                    'status' => false,
                    'message' => 'Contact & Password does not match with our record.',
                ], 401);
            }
            return response()->json([
                'status' => true,
                'message' => 'Logged In Successfully',
                'id'=>$check->id,
                'type'=>'staffAdmin',
                'name'=>$check->name,
                'email'=>$check->email,
                'contact'=>$check->contact
            ], 200);
             
        }
        
        $builderAdmin = BuilderAdmin::where('email',$request->email)->first();
        if($builderAdmin)
        {
           $check = BuilderAdmin::where('email',$request->email)->where('password',$request->password)->where('status',1)->first();
            if(!$check)
            {
                return response()->json([
                    'status' => false,
                    'message' => 'Contact & Password does not match with our record.',
                ], 401);
            }
            return response()->json([
                'status' => true,
                'message' => 'Logged In Successfully',
                'id'=>$check->id,
                'type'=>'builderAdmin',
                'name'=>$check->name,
                'email'=>$check->email,
                'contact'=>$check->contact
            ], 200);
             
        }
        
        $builder = Builder::where('email',$request->email)->first();
        if($builder)
        {
            $check = Builder::where('email',$request->email)->where('password',$request->password)->where('status',1)->first();
            if(!$check)
            {
                return response()->json([
                    'status' => false,
                    'message' => 'Contact & Password does not match with our record.',
                ], 401);
            }
            $admin = $check->admin_id;
            $adminName = BuilderAdmin::where('id',$admin)->first();
            return response()->json([
                'status' => true,
                'message' => 'Logged In Successfully',
                'id'=>$check->id,
                'type'=>'builder',
                'name'=>$check->name,
                'email'=>$check->email,
                'contact'=>$check->contact,
                'company'=>$check->company,
                'location'=>$check->location,
                'builderAdmin_id'=>$check->admin_id,
                'builderAdmin'=>$adminName->name,
                
            ], 200);
        }
        
        return response()->json([
                    'status' => false,
                    'message' => 'Contact & Password does not match with our record.',
                ], 401);
        
    }
}
