<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Staff;
use App\Models\StaffAdmin;
use App\Models\BuilderAdmin;
use App\Models\Builder;
use App\Models\Record;
use App\Models\Location;
use Illuminate\Support\Facades\Validator;
use Carbon\Carbon;

class LocationController extends Controller
{
    
    public function staffLocations(Request $request)
    {
        $validateUser = Validator::make($request->all(), 
            [
                'staff_id' => 'required|exists:staff,id',
            ]);
        if($validateUser->fails()){
                return response()->json([
                    'status' => false,
                   
                    'message' => $validateUser->errors()->first()
                ], 401);
            }
        $staff = Staff::where('id',$request->staff_id)->first();    
        $admin = $staff->admin_id;
        $staffIDs = Staff::where('admin_id',$admin)->pluck('id');
        $recordsIDs = Record::whereIn('staff_id',$staffIDs)->select('location_id')->distinct()->get();
        $locations =  Location::whereIn('id',$recordsIDs)->get();
        return response()->json([
                'status' => true,
                'message' => 'success',
                'data'=>$locations,
            ], 200);
    }
    
    public function builderLocations(Request $request)
    {
        $validateUser = Validator::make($request->all(), 
            [
                'builder_id' => 'required|exists:builders,id',
            ]);
        if($validateUser->fails()){
                return response()->json([
                    'status' => false,
                    
                    'message' => $validateUser->errors()->first()
                ], 401);
            }
        $builder = Builder::where('id',$request->builder_id)->first();
        $admin = $builder->admin_id;
        $recordsIDs = Record::where('builder_id',$admin)->select('location_id')->distinct()->get();
        $locations =  Location::whereIn('id',$recordsIDs)->get();
        return response()->json([
                'status' => true,
                'message' => 'success',
                'data'=>$locations,
            ], 200);
    }
    
    public function locationsReports(Request $request)
    {
        $validateUser = Validator::make($request->all(), 
            [
                'location_id' => 'required|exists:locations,id',
            ]);
        if($validateUser->fails()){
                return response()->json([
                    'status' => false,
                    
                    'message' => $validateUser->errors()->first()
                ], 401);
            }
        //$record = Record::where('location_id',$request->location_id)->get();
        $data = Record::select('records.*','builder_admins.id as builder_id','builder_admins.name as builder_name','staff.id as staff_id','staff.name as staff_name')->join('builder_admins','builder_admins.id','=','records.builder_id')->join('staff','staff.id','=','records.staff_id')->where('records.status',1)->where('records.location_id',$request->location_id)->get();
        $dame = array();
        foreach($data as $d)
        {
            $k['id'] = $d->id;
            $k['staff_id'] = $d->staff_id;
            $k['builder_id'] = $d->builder_id;
            $k['location_id'] = $d->location_id;
            $k['staff_name'] = $d->staff_name;
            $k['builder_name'] = $d->builder_name;
            $k['company'] = $d->company;
            $k['location'] = $d->location;
            $k['location_lat'] = $d->location_lat;
            $k['location_long'] = $d->location_long;
            $k['date'] = Carbon::parse($d->created_at)->format('d-m-Y');
            $k['time'] = Carbon::parse($d->created_at)->format('h:i A');
            $dame[] = $k;
        }
        return response()->json([
                'status' => true,
                'message' => 'success',
                'data'=>$dame,
            ], 200);
    }
    
    
    public function staffLocationAdd(Request $request)
    {
        $validateUser = Validator::make($request->all(), 
            [
                'staff_id' => 'required|exists:staff,id',
                'location' => 'required',
                
            ]);
        if($validateUser->fails()){
                return response()->json([
                    'status' => false,
                    
                    'message' => $validateUser->errors()->first()
                ], 401);
            }
        $data = new Location;
        $data->name = $request->location;
        $data->loc_lat = $request->loc_lat;
        $data->loc_long = $request->loc_long;
        $data->save();
        
        return response()->json([
                'status' => true,
                'message' => 'success',
                'id'=>$data->id,
            ], 200);
    }
    
}
