<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Staff;
use App\Models\StaffAdmin;
use App\Models\BuilderAdmin;
use App\Models\Builder;
use App\Models\Record;
use App\Models\Location;
use Illuminate\Support\Facades\Validator;
use Carbon\Carbon;

class BuilderController extends Controller
{
    public function builderList(Request $request)
    {
        $validateUser = Validator::make($request->all(), 
            [
                'staff_id' => 'required|exists:staff,id',
            ]);
        if($validateUser->fails()){
                return response()->json([
                    'status' => false,
                    
                    'message' => $validateUser->errors()->first()
                ], 401);
            }
        $builder = BuilderAdmin::where('status',1)->get();    
        foreach($builder as $test)
        {
            $k['id'] = $test->id;
            $k['name'] = $test->name;
            $k['email'] = $test->email;
            $k['contact'] = $test->contact;
            $k['company'] = $test->company;
            $k['location'] = $test->location;
            $k['date'] = Carbon::parse($test->created_at)->format('d-m-Y');
            $k['time'] = Carbon::parse($test->created_at)->format('h:i A');
            $finalData[] = $k;
        }
        return response()->json([
                'status' => true,
                'message' => 'success',
                'data'=>$finalData,
            ], 200);
    }
}
