<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Staff;
use App\Models\StaffAdmin;
use App\Models\OnSiteStaff;
use App\Models\Builder;
use App\Models\BuilderAdmin;
use App\Models\Hazard;
use App\Models\Inspection;
use App\Models\PreStartChecklist;
use App\Models\Record;
use App\Models\RecordImage;
use Session;


class RecordController extends Controller
{
    public function index()
    {
        $data = Record::select('records.*','builder_admins.id as builder_id','builder_admins.name as builder_name','staff.id as staff_id','staff.name as staff_name')->join('builder_admins','builder_admins.id','=','records.builder_id')->join('staff','staff.id','=','records.staff_id')->get();
        return view('admin.record',compact('data'));
    }
    
    public function staffReport(Request $request,$id)
    {
        $data = Record::select('records.*','builder_admins.name as builder_name','staff.name as staff_name')->join('builder_admins','builder_admins.id','=','records.builder_id')->join('staff','staff.id','=','records.staff_id')->where('records.staff_id',$id)->get();
        return view('admin.record',compact('data'));
    }
    
    public function builderReport(Request $request,$id)
    {
        $data = Record::select('records.*','builder_admins.name as builder_name','staff.name as staff_name')->join('builder_admins','builder_admins.id','=','records.builder_id')->join('staff','staff.id','=','records.staff_id')->where('records.builder_id',$id)->get();
        return view('admin.record',compact('data'));
    }
    
    public function locationReport(Request $request,$id)
    {
        $data = Record::select('records.*','builder_admins.name as builder_name','staff.name as staff_name')->join('builder_admins','builder_admins.id','=','records.builder_id')->join('staff','staff.id','=','records.staff_id')->where('records.location_id',$id)->get();
        return view('admin.record',compact('data'));
    }
    
    public function clientReport(Request $request,$id)
    {
        $builderClient = Builder::where('id',$id)->first();
        $builderAdminId = $builderClient->admin_id;
        $data = Record::select('records.*','builder_admins.name as builder_name','staff.name as staff_name')->join('builder_admins','builder_admins.id','=','records.builder_id')->join('staff','staff.id','=','records.staff_id')->where('records.builder_id',$builderAdminId)->get();
        return view('admin.record',compact('data'));
    }
    
    public function staffAdminReport(Request $request,$id)
    {
        $staff_id = Staff::where('admin_id',$id)->pluck('id');
        $data = Record::select('records.*','builder_admins.name as builder_name','staff.name as staff_name')->join('builder_admins','builder_admins.id','=','records.builder_id')->join('staff','staff.id','=','records.staff_id')->whereIn('records.staff_id',$staff_id)->get();
        return view('admin.record',compact('data'));
    }
    
    public function changeRecordStatus(Request $request)
    {
        if($request->ajax())
        {
            $data = $request->all();
            if($data['status']=='Active')
            {
                $status = 0;    
            }else
            {
                $status = 1;
            }
            Record::where('id',$data['record_id'])->update(['status'=>$status]);
            return response()->json(['status'=>$status,'record_id'=>$data['record_id']]);
        }
    }
    
    public function store(Request $request)
    {
        $staff = Staff::where('id',$request->staff_name)->first();
        $builder = BuilderAdmin::where('id',$request->builder_name)->first();
        
        //update main records detail
        $data = Record::find($request->record_id);
        $data->staff_name = $staff->name;
        $data->staff_id = $request->staff_name;
        $data->company = $request->c_name;
        $data->builder_name = $builder->name;
        $data->builder_id = $request->builder_name;
        $data->location = $request->location;
        $data->damage = $request->damage;
        $data->save();
        
        // update PreStartChecklist details
        $precheckList = PreStartChecklist::where('record_id',$request->record_id)->first();
        $prechecklist = PreStartChecklist::find($precheckList->id);
        if($request->has('site_signage')){ $prechecklist->site_signage = 1; } else { $prechecklist->site_signage = 0; }
        if($request->has('contact_numbers')){ $prechecklist->contact_numbers = 1;} else { $prechecklist->contact_numbers = 0; }
        if($request->has('msds_sheets')){ $prechecklist->msds_sheets = 1;} else { $prechecklist->msds_sheets = 0; }
        if($request->has('fire_extinguisher')){ $prechecklist->fire_extinguisher = 1;} else { $prechecklist->fire_extinguisher = 0; }
        if($request->has('washroom_facility')){ $prechecklist->washroom_facility = 1;} else { $prechecklist->washroom_facility = 0; }
        if($request->has('sub_cont_drient')){ $prechecklist->sub_cont_drient = 1;} else{ $prechecklist->sub_cont_drient = 0; }
        if($request->has('w_safety')){ $prechecklist->w_safety = 1;} else{ $prechecklist->w_safety =0; }
        if($request->has('ad_supply_eyewash')){ $prechecklist->ad_supply_eyewash = 1;} else{ $prechecklist->ad_supply_eyewash =0; }
        if($request->has('utility_clearence')){ $prechecklist->utility_clearence = 1;} else{ $prechecklist->utility_clearence =0; }
        if($request->has('public_protection')){ $prechecklist->public_protection = 1;} else{ $prechecklist->public_protection =0; }
        if($request->has('communication_device')){ $prechecklist->communication_device = 1;} else{ $prechecklist->communication_device =0; }
        if($request->has('other')){ $prechecklist->other = 1;} else{ $prechecklist->other =0; }
        $prechecklist->save();
        
        // update Inspection details
        $inspectionList = Inspection::where('record_id',$request->record_id)->first();
        $inspectionlist = Inspection::find($inspectionList->id);
        if($request->has('i_emergency_response')){ $inspectionlist->emergency_response = 1; } else { $inspectionlist->emergency_response = 0; }
        if($request->has('i_first_aid_kit')){ $inspectionlist->first_aid_kit = 1; } else { $inspectionlist->first_aid_kit = 0; }
        if($request->has('i_ladders_walkway')){ $inspectionlist->ladders_walkway = 1; } else { $inspectionlist->ladders_walkway = 0; }
        if($request->has('i_lockout_tagout')){ $inspectionlist->lockout_tagout = 1; } else { $inspectionlist->lockout_tagout = 0; }
        if($request->has('i_electrical_panel')){ $inspectionlist->electrical_panel = 1; } else { $inspectionlist->electrical_panel = 0; }
        if($request->has('i_ppe')){ $inspectionlist->ppe = 1; } else { $inspectionlist->ppe = 0; }
        if($request->has('i_fire_extinguisher')){ $inspectionlist->fire_extinguisher = 1; } else { $inspectionlist->fire_extinguisher = 0; }
        if($request->has('i_signage')){ $inspectionlist->signage = 1; } else { $inspectionlist->signage = 0; }
        if($request->has('i_msds')){ $inspectionlist->msds = 1; } else { $inspectionlist->msds = 0; }
        if($request->has('i_access_egress')){ $inspectionlist->access_egress = 1; } else { $inspectionlist->access_egress = 0; }
        if($request->has('i_tools')){ $inspectionlist->tools = 1; } else { $inspectionlist->tools = 0; }
        if($request->has('i_housekeeping')){ $inspectionlist->housekeeping = 1; } else { $inspectionlist->housekeeping = 0; }
        if($request->has('i_guardrail')){ $inspectionlist->guardrail = 1; } else { $inspectionlist->guardrail = 0; }
        if($request->has('i_utilities')){ $inspectionlist->utilities = 1; } else { $inspectionlist->utilities = 0; }
        if($request->has('i_fall_protection')){ $inspectionlist->fall_protection = 1; } else { $inspectionlist->fall_protection = 0; }
        if($request->has('i_other')){ $inspectionlist->other = 1; } else { $inspectionlist->other = 0; }
        $inspectionlist->save();
        
        // update Hazard details
        Hazard::where('record_id',$request->record_id)->delete();
        $severity = $request->severity;
        $hazard = $request->hazard;
        $hazardDetail = $request->hazard_detail;
        
        for($i=0; $i<=count($severity)-1; $i++) {
          $hazards = new Hazard;
          $hazards->record_id = $request->record_id;
          $hazards->rank = $severity[$i];
          $hazards->hazard = $hazard[$i];
          $hazards->detail = $hazardDetail[$i];
          $hazards->save();
        }
        //update staff on site
        OnSiteStaff::where('record_id',$request->record_id)->delete();
        $staffOnSite = $request->staffonsite;
        for($i=0; $i<=count($staffOnSite)-1; $i++) {
          $hazards = new OnSiteStaff;
          $hazards->record_id = $request->record_id;
          $hazards->detail = $staffOnSite[$i];
          $hazards->save();
        }
        
        return redirect('/records');
    }
    
    public function detail(Request $request,$id)
    {
        $builder = BuilderAdmin::where('status',1)->get();
        $staff = Staff::where('status',1)->get();
        $data = Record::where('id',$id)->first();
        $precheckList = PreStartChecklist::where('record_id',$id)->first();
        $inspectionList = Inspection::where('record_id',$id)->first();
        $images = RecordImage::where('record_id',$id)->get();
        $hazard = Hazard::where('record_id',$id)->get();
        $onSiteStaff = OnSiteStaff::where('record_id',$id)->get();
        return view('admin.record-detail',compact('data','precheckList','inspectionList','images','hazard','builder','staff','onSiteStaff'));
    }
    
    public function updateRecordImage(Request $request,$id)
    {
        $save = RecordImage::find($id); 
        if($request->hasFile('image')) {
          unlink("site_images/".$save->image);
            $mediaFiles = $request->image;
                //$path = $mediaFiles->store('public/ADSimages');
               $originName = $request->file('image')->getClientOriginalName();
            $fileName = pathinfo($originName,PATHINFO_FILENAME);
            $extension = $request->file('image')->getClientOriginalExtension();
            $fileName = $fileName.'_'.time().'.'.$extension;
                ///$name = $mediaFiles->getClientOriginalName();
                //$mediaFiles->file('images')->move(public_path().'/ADSimages/', $name);
                $mediaFiles->move(public_path().'/site_images/', $fileName);
                //store image file into directory and db
                $save->image = $fileName;
                $save->save();
          return response()->json(['status' => 200,'success' => true, 'error'=>false]);
        }
        else
        {
            return response()->json(['status' => 404, 'error'=>"no file submitted"]);
        }
    }
    
    public function uploadRecordImage(Request $request,$id)
    {
        $save = new RecordImage; 
        if($request->hasFile('image')) {
          
            $mediaFiles = $request->image;
                //$path = $mediaFiles->store('public/ADSimages');
               $originName = $request->file('image')->getClientOriginalName();
            $fileName = pathinfo($originName,PATHINFO_FILENAME);
            $extension = $request->file('image')->getClientOriginalExtension();
            $fileName = $fileName.'_'.time().'.'.$extension;
                ///$name = $mediaFiles->getClientOriginalName();
                //$mediaFiles->file('images')->move(public_path().'/ADSimages/', $name);
                $mediaFiles->move(public_path().'/site_images/', $fileName);
                //store image file into directory and db
                $save->image = $fileName;
                $save->record_id = $id;
                $save->save();
          return response()->json(['status' => 200,'success' => true, 'error'=>false]);
        }
        else
        {
            return response()->json(['status' => 404, 'error'=>"no file submitted"]);
        }
    }
    
    public function deleteMultiple(Request $request)
    {
        //$idarray = explode(",",$request->idsArr);
        foreach($request->idsArr as $id)
        {
            $recordId = Record::find($id);
           $images =  RecordImage::where('record_id',$recordId)->get();
           foreach($images as $img)
           {
               $save = RecordImage::find($img->id); 
              unlink("site_images/".$save->image);
                $data = RecordImage::where('id',$id)->delete();
           }
            $data = Record::where('id',$id)->delete();
        
        }
        
        return response()->json(['success' => true,'id'=>$request->idsArr]);
    }
    
    public function deleteRecordImage(Request $request,$id)
    {
        $save = RecordImage::find($id); 
          unlink("site_images/".$save->image);
        $data = RecordImage::where('id',$id)->delete();   
          return response()->json(['status' => 200,'success' => true, 'error'=>false]);
        
    }
    
}
