<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\BuilderAdmin;
use App\Models\Builder;
use Session;

class BuilderController extends Controller
{
    public function index()
    {
        $builderAdmins = BuilderAdmin::where('status','1')->get();
        $data = Builder::select('builders.*','builder_admins.name as adminName','builder_admins.id as builderAdminID')->join('builder_admins','builder_admins.id','=','builders.admin_id')->get();
        return view('admin.builder',compact('data','builderAdmins'));
    }
    
    public function changeBuilderStatus(Request $request)
    {
        if($request->ajax())
        {
            $data = $request->all();
            if($data['status']=='Active')
            {
                $status = 0;    
            }else
            {
                $status = 1;
            }
            Builder::where('id',$data['builder_id'])->update(['status'=>$status]);
            return response()->json(['status'=>$status,'builder_id'=>$data['builder_id']]);
        }
    }
    
    public function detail(Request $request)
    {
        $id = $request->input('id');
        $item = Builder::find($id);
        $output = array(
            'name'    =>  $item->name,
            'email'    =>  $item->email,
            'contact'    =>  $item->contact,
            'company'    =>  $item->company,
            'password'    =>  $item->password,
            'locationn'    =>  $item->location,
            'builderId'     =>  $item->id,
            'adminId'     =>  $item->admin_id
        );
        echo json_encode($output);
    }
    
    public function builderSave(Request $request)
    {
         $validated = $request->validate([
            'username' => 'required',
            'contact'=>'required|unique:staff_admins|unique:staff|unique:builder_admins|unique:builders',
            'email'=>'required|unique:staff_admins|unique:staff|unique:builder_admins|unique:builders',
            'password' => 'required',
            'company' => 'required',
            'location' => 'required',
            'builderAdmin' => 'required',
        ]);
        
        $data = new Builder;
        $data->name = $request->input('username');
        $data->contact = $request->input('contact');
        $data->email = $request->input('email');
        $data->company = $request->input('company');
        $data->location = $request->input('location');
        $data->password = $request->input('password');
        $data->admin_id = $request->input('builderAdmin');
        $data->save();
        return response()->json(['success' => true]);
    }
    
    public function update(Request $request)
    {
        $game = $request->all();
        $data = Builder::find($request->id);
        $data->name = $request->input('username');
        $data->contact = $request->input('contact');
        $data->email = $request->input('email');
        $data->company = $request->input('company');
        $data->password = $request->input('password');
        $data->location = $request->input('location');
        $data->admin_id = $request->input('adminId');
        $data->save();
        return response()->json(['success' => true, 'error'=>$game]);
        
    }
    
    public function destroy(Request $request,$id)
    {
        Builder::find($id)->delete();
        Session::flash('error', 'Builder Removed');
        return back();
    }
}
